<?php
/**
 * BankItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  Khipu
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2015 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Khipu\Model;

use \ArrayAccess;
/**
 * BankItem Class Doc Comment
 *
 * @category    Class
 * @description 
 * @package     Khipu
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BankItem implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'bank_id' => 'string',
        'name' => 'string',
        'message' => 'string',
        'min_amount' => 'double',
        'type' => 'string',
        'parent' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'bank_id' => 'bank_id',
        'name' => 'name',
        'message' => 'message',
        'min_amount' => 'min_amount',
        'type' => 'type',
        'parent' => 'parent'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'bank_id' => 'setBankId',
        'name' => 'setName',
        'message' => 'setMessage',
        'min_amount' => 'setMinAmount',
        'type' => 'setType',
        'parent' => 'setParent'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'bank_id' => 'getBankId',
        'name' => 'getName',
        'message' => 'getMessage',
        'min_amount' => 'getMinAmount',
        'type' => 'getType',
        'parent' => 'getParent'
    );
  
    
    /**
      * $bank_id Identificador del banco
      * @var string
      */
    protected $bank_id;
    
    /**
      * $name Nombre del banco
      * @var string
      */
    protected $name;
    
    /**
      * $message Mensaje con particularidades del banco
      * @var string
      */
    protected $message;
    
    /**
      * $min_amount Monto mínimo que acepta el banco en un pago
      * @var double
      */
    protected $min_amount;
    
    /**
      * $type Tipo de banco
      * @var string
      */
    protected $type;
    
    /**
      * $parent Identificador del banco padre (si un banco tiene banca personas y empresas, el primero será el padre del segundo)
      * @var string
      */
    protected $parent;
    

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            $this->bank_id = $data["bank_id"];
            $this->name = $data["name"];
            $this->message = $data["message"];
            $this->min_amount = $data["min_amount"];
            $this->type = $data["type"];
            $this->parent = $data["parent"];
        }
    }
    
    /**
     * Gets bank_id
     * @return string
     */
    public function getBankId()
    {
        return $this->bank_id;
    }
  
    /**
     * Sets bank_id
     * @param string $bank_id Identificador del banco
     * @return $this
     */
    public function setBankId($bank_id)
    {
        
        $this->bank_id = $bank_id;
        return $this;
    }
    
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name Nombre del banco
     * @return $this
     */
    public function setName($name)
    {
        
        $this->name = $name;
        return $this;
    }
    
    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
  
    /**
     * Sets message
     * @param string $message Mensaje con particularidades del banco
     * @return $this
     */
    public function setMessage($message)
    {
        
        $this->message = $message;
        return $this;
    }
    
    /**
     * Gets min_amount
     * @return double
     */
    public function getMinAmount()
    {
        return $this->min_amount;
    }
  
    /**
     * Sets min_amount
     * @param double $min_amount Monto mínimo que acepta el banco en un pago
     * @return $this
     */
    public function setMinAmount($min_amount)
    {
        
        $this->min_amount = $min_amount;
        return $this;
    }
    
    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
  
    /**
     * Sets type
     * @param string $type Tipo de banco
     * @return $this
     */
    public function setType($type)
    {
        
        $this->type = $type;
        return $this;
    }
    
    /**
     * Gets parent
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }
  
    /**
     * Sets parent
     * @param string $parent Identificador del banco padre (si un banco tiene banca personas y empresas, el primero será el padre del segundo)
     * @return $this
     */
    public function setParent($parent)
    {
        
        $this->parent = $parent;
        return $this;
    }
    
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(get_object_vars($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(get_object_vars($this));
        }
    }
}
