<?php
/**
 * PaymentsApi
 * PHP version 5
 *
 * @category Class
 * @package  Khipu
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2015 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace Khipu\Client;

use \Khipu\Configuration;
use \Khipu\ApiClient;
use \Khipu\ApiException;
use \Khipu\ObjectSerializer;

/**
 * PaymentsApi Class Doc Comment
 *
 * @category Class
 * @package  Khipu
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PaymentsApi
{

    /**
     * API Client
     * @var \Khipu\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \Khipu\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://khipu.com/api/2.0');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \Khipu\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \Khipu\ApiClient $apiClient set the API client
     * @return PaymentsApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    
    /**
     * paymentsGet
     *
     * Obtener información de un pago
     *
     * @param string $notification_token Token de notifiación recibido usando la API de notificaiones 1.3 o superior. (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * @return \Khipu\Model\PaymentsResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsGet($notification_token, $options = null)
    {
        
        // verify the required parameter 'notification_token' is set
        if ($notification_token === null) {
            throw new \InvalidArgumentException('Missing the required parameter $notification_token when calling paymentsGet');
        }
  
        // parse inputs
        $resourcePath = "/payments";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "GET";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        // query params
        $queryParams['notification_token'] = $this->apiClient->getSerializer()->toQueryValue($notification_token);
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        

        if( $options != null ) {
            
        }

        

        if( $options != null ) {
          
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsPost
     *
     * Crear un pago
     *
     * @param string $subject Motivo (requerido)
     * @param string $currency El código de moneda en formato ISO-4217 (requerido)
     * @param double $amount El monto del cobro. Sin separador de miles y usando &#39;.&#39; como separador de decimales. Hasta 4 lugares decimales, dependiendo de la moneda (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * - string 'transaction_id' Identificador propio de la  transacción. Ej: número de factura u orden de compra (opcional)
     * - string 'custom' Parámetro para enviar información personalizada de la transacción. Ej: documento XML con el detalle del carro de compra (opcional)
     * - string 'body' Descripción del cobro (opcional)
     * - string 'bank_id' Identificador del banco para usar en el pago (opcional)
     * - string 'return_url' La dirección URL a donde enviar al cliente mientras el pago está siendo verificado (opcional)
     * - string 'cancel_url' La dirección URL a donde enviar al cliente si decide no hacer hacer la transacción (opcional)
     * - string 'picture_url' Una dirección URL de una foto de tu producto o servicio (opcional)
     * - string 'notify_url' La dirección del web-service que utilizará khipu para notificar cuando el pago esté conciliado (opcional)
     * - string 'contract_url' La dirección URL del archivo PDF con el contrato a firmar mediante este pago. El cobrador debe estar habilitado para este servicio y el campo &#39;fixed_payer_personal_identifier&#39; es obgligatorio (opcional)
     * - string 'notify_api_version' Versión de la API de notifiaciones para recibir avisos por web-service (opcional)
     * - \DateTime 'expires_date' Fecha de expiración del cobro. Pasada esta fecha el cobro es inválido. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z (opcional)
     * - bool 'send_email' Si es &#39;true&#39;, se enviará una solicitud de cobro al correo especificado en &#39;payer_email&#39; (opcional)
     * - string 'payer_name' Nombre del pagador. Es obligatorio cuando send_email es &#39;true&#39; (opcional)
     * - string 'payer_email' Correo del pagador. Es obligatorio cuando send_email es &#39;true&#39; (opcional)
     * - bool 'send_reminders' Si es &#39;true&#39;, se enviarán recordatorios de cobro. (opcional)
     * - string 'responsible_user_email' Correo electrónico del responsable de este cobro, debe corresponder a un usuario khipu con permisos para cobrar usando esta cuenta de cobro (opcional)
     * - string 'fixed_payer_personal_identifier' Identificador personal. Si se especifica, solo podrá ser pagado usando ese identificador (opcional)
     * - double 'integrator_fee' Comisión para el integrador. Sólo es válido si la cuenta de cobro tiene una cuenta de integrador asociada (opcional)
     * - bool 'collect_account_uuid' Para cuentas de cobro con más cuenta propia. Permite elegir la cuenta donde debe ocurrir la transferencia. (opcional)
     * - string 'confirm_timeout_date' Fecha de rendición del cobro. Es también la fecha final para poder reembolsar el cobro. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z (opcional)
     * - string 'mandatory_payment_method' Si se especifica, el cobro sólo se podrá pagar utilizando ese medio de pago. El valor para el campo de obtiene consultando el endpoint &#39;Consulta medios de pago disponibles&#39;. (opcional)
     * @return \Khipu\Model\PaymentsCreateResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsPost($subject, $currency, $amount, $options = null)
    {
        
        // verify the required parameter 'subject' is set
        if ($subject === null) {
            throw new \InvalidArgumentException('Missing the required parameter $subject when calling paymentsPost');
        }
        // verify the required parameter 'currency' is set
        if ($currency === null) {
            throw new \InvalidArgumentException('Missing the required parameter $currency when calling paymentsPost');
        }
        // verify the required parameter 'amount' is set
        if ($amount === null) {
            throw new \InvalidArgumentException('Missing the required parameter $amount when calling paymentsPost');
        }
  
        // parse inputs
        $resourcePath = "/payments";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "POST";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        

        if( $options != null ) {
            
        }

        // form params
        $formParams['subject'] = $this->apiClient->getSerializer()->toFormValue($subject);
        // form params
        $formParams['currency'] = $this->apiClient->getSerializer()->toFormValue($currency);
        // form params
        $formParams['amount'] = $this->apiClient->getSerializer()->toFormValue($amount);
        

        if( $options != null ) {
          // form params
          if (array_key_exists("transaction_id", $options) && $options["transaction_id"] != null) {
            $formParams['transaction_id'] = $this->apiClient->getSerializer()->toFormValue($options["transaction_id"]);
          }// form params
          if (array_key_exists("custom", $options) && $options["custom"] != null) {
            $formParams['custom'] = $this->apiClient->getSerializer()->toFormValue($options["custom"]);
          }// form params
          if (array_key_exists("body", $options) && $options["body"] != null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($options["body"]);
          }// form params
          if (array_key_exists("bank_id", $options) && $options["bank_id"] != null) {
            $formParams['bank_id'] = $this->apiClient->getSerializer()->toFormValue($options["bank_id"]);
          }// form params
          if (array_key_exists("return_url", $options) && $options["return_url"] != null) {
            $formParams['return_url'] = $this->apiClient->getSerializer()->toFormValue($options["return_url"]);
          }// form params
          if (array_key_exists("cancel_url", $options) && $options["cancel_url"] != null) {
            $formParams['cancel_url'] = $this->apiClient->getSerializer()->toFormValue($options["cancel_url"]);
          }// form params
          if (array_key_exists("picture_url", $options) && $options["picture_url"] != null) {
            $formParams['picture_url'] = $this->apiClient->getSerializer()->toFormValue($options["picture_url"]);
          }// form params
          if (array_key_exists("notify_url", $options) && $options["notify_url"] != null) {
            $formParams['notify_url'] = $this->apiClient->getSerializer()->toFormValue($options["notify_url"]);
          }// form params
          if (array_key_exists("contract_url", $options) && $options["contract_url"] != null) {
            $formParams['contract_url'] = $this->apiClient->getSerializer()->toFormValue($options["contract_url"]);
          }// form params
          if (array_key_exists("notify_api_version", $options) && $options["notify_api_version"] != null) {
            $formParams['notify_api_version'] = $this->apiClient->getSerializer()->toFormValue($options["notify_api_version"]);
          }// form params
          if (array_key_exists("expires_date", $options) && $options["expires_date"] != null) {
            $formParams['expires_date'] = $this->apiClient->getSerializer()->toFormValue($options["expires_date"]);
          }// form params
          if (array_key_exists("send_email", $options) && $options["send_email"] != null) {
            $formParams['send_email'] = $this->apiClient->getSerializer()->toFormValue($options["send_email"]);
          }// form params
          if (array_key_exists("payer_name", $options) && $options["payer_name"] != null) {
            $formParams['payer_name'] = $this->apiClient->getSerializer()->toFormValue($options["payer_name"]);
          }// form params
          if (array_key_exists("payer_email", $options) && $options["payer_email"] != null) {
            $formParams['payer_email'] = $this->apiClient->getSerializer()->toFormValue($options["payer_email"]);
          }// form params
          if (array_key_exists("send_reminders", $options) && $options["send_reminders"] != null) {
            $formParams['send_reminders'] = $this->apiClient->getSerializer()->toFormValue($options["send_reminders"]);
          }// form params
          if (array_key_exists("responsible_user_email", $options) && $options["responsible_user_email"] != null) {
            $formParams['responsible_user_email'] = $this->apiClient->getSerializer()->toFormValue($options["responsible_user_email"]);
          }// form params
          if (array_key_exists("fixed_payer_personal_identifier", $options) && $options["fixed_payer_personal_identifier"] != null) {
            $formParams['fixed_payer_personal_identifier'] = $this->apiClient->getSerializer()->toFormValue($options["fixed_payer_personal_identifier"]);
          }// form params
          if (array_key_exists("integrator_fee", $options) && $options["integrator_fee"] != null) {
            $formParams['integrator_fee'] = $this->apiClient->getSerializer()->toFormValue($options["integrator_fee"]);
          }// form params
          if (array_key_exists("collect_account_uuid", $options) && $options["collect_account_uuid"] != null) {
            $formParams['collect_account_uuid'] = $this->apiClient->getSerializer()->toFormValue($options["collect_account_uuid"]);
          }// form params
          if (array_key_exists("confirm_timeout_date", $options) && $options["confirm_timeout_date"] != null) {
            $formParams['confirm_timeout_date'] = $this->apiClient->getSerializer()->toFormValue($options["confirm_timeout_date"]);
          }// form params
          if (array_key_exists("mandatory_payment_method", $options) && $options["mandatory_payment_method"] != null) {
            $formParams['mandatory_payment_method'] = $this->apiClient->getSerializer()->toFormValue($options["mandatory_payment_method"]);
          }
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsCreateResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsCreateResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsCreateResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdGet
     *
     * Obtener información de un pago
     *
     * @param string $id Identificador del pago (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * @return \Khipu\Model\PaymentsResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdGet($id, $options = null)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdGet');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "GET";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        // path params
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        

        if( $options != null ) {
            
        }

        

        if( $options != null ) {
          
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdDelete
     *
     * Borrar un pago
     *
     * @param string $id Identificador del pago (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * @return \Khipu\Model\SuccessResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdDelete($id, $options = null)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdDelete');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "DELETE";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        // path params
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        

        if( $options != null ) {
            
        }

        

        if( $options != null ) {
          
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\SuccessResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\SuccessResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\SuccessResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdConfirmPost
     *
     * Confirmar el pago.
     *
     * @param string $id Identificador del pago (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * @return \Khipu\Model\SuccessResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdConfirmPost($id, $options = null)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdConfirmPost');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}/confirm";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "POST";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        // path params
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        

        if( $options != null ) {
            
        }

        

        if( $options != null ) {
          
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\SuccessResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\SuccessResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\SuccessResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdRefundsPost
     *
     * Reembolsar total o parcialmente un pago
     *
     * @param string $id Identificador del pago (requerido)
     * @param array $options Arreglo de par��metros opcionales (opcional)
     * - double 'amount' El monto a devolver. Sin separador de miles y usando &#39;.&#39; como separador de decimales. Hasta 4 lugares decimales, dependiendo de la moneda. Si se omite el reembolso se hará por el total del monto del pago. (opcional)
     * @return \Khipu\Model\SuccessResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdRefundsPost($id, $options = null)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdRefundsPost');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}/refunds";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "POST";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        

        if( $options != null ) {
          
        }


        

        if( $options != null ) {
            
        }


        // path params
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        

        if( $options != null ) {
            
        }

        

        if( $options != null ) {
          // form params
          if (array_key_exists("amount", $options) && $options["amount"] != null) {
            $formParams['amount'] = $this->apiClient->getSerializer()->toFormValue($options["amount"]);
          }
        }

        

        if( $options != null ) {
            
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }
        if (isset($_tempBody)){
          $json_body = json_encode($this->apiClient->getSerializer()->sanitizeForSerialization($_tempBody));
          $toSign .="&".$json_body;
        }
        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\SuccessResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\SuccessResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\SuccessResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
}
